/*----------------------------------------------------------------------------*/
/*
 *	Sample4.c
 *	2007/10/25
 *	- 
 *	2020/02/18C 
 *	- comportopenۂ̏ύX
 *	- RS204MDΉ (ReadmeSample.txtQ)
 */

/*----------------------------------------------------------------------------*/
/*	Windows APIgpR}hRSV[YT[{̐
 *	(RpCMINGWgpj
 *
 *	(*)T[{ID܂B
 *	T[{ID̏rɃT[{̓d؂ȂłB
 *  gp̃T[{ID͐ɓ삷T[{ID̕Kv܂B
 *  T[{ID̃T[{𕡐ڑԂł͓삵܂B
 *
 *	T[{̎ނɂďԂ͈Ⴂ܂̂ŒKvłB
 *	RS601CR 9bȏ LEDL
 *	RS301CR 1bȏ
 *	RS302CD 1bȏ
 *	RS303MR 1bȏ
 *	RS304MD 1bȏ
 *	RS401CR 9bȏ
 *	RS402CD 9bȏ
 *	RS405CB 1bȏ
 *	RS406CB 1bȏ
 *	RS204MD 1bȏ
 *
 *	̃t@ĆATAB=4ݒłŋLqĂ܂B
 *
 *	T[{֑MpPbge̐ɂẮAʓrAT[{̎戵
 *	QƂĂB
 *
 *	(C) 2006 FUTABA Corp.
 *
 */

/*----------------------------------------------------------------------------*/
/*
 *	vOTv
 *
 *	Windows APIgpăR}hRSV[YT[{𓮍삳
 *	T[{ID́Au1vƂ܂B
 *	T[{ID1Ŗꍇɂ͏CKvłB
 *	ʐM|[ǵAuCOM1vƂ܂B
 *	ʐM|[gCOM1Ŗꍇɂ͏CKvłB
 *  T[{ID̃T[{𕡐ڑԂł͓삵܂B
 *
 *	1)Windows APIgpĒʐM|[g
 *		gpʐM|[g͊ɂ킹ďCKvł
 *	2)T[{̃gNOFFɂ܂
 *	3)T[{ID2ɕύXď݂܂
 *	4)T[{ւ̃f[^̏݊҂܂
 *	5)T[{IDǂݏo܂
 *
 *	sӁt
 *  gp̃T[{ID͐ɓ삷T[{ID̕Kv܂B
 *	T[{ID̏rɃT[{̓d؂ȂłB
 *	T[{ID̏ɃT[{̓d؂ꂽꍇɂ͓삵ȂȂꍇ
 *	܂B
 *	T[{ID̏Ԃ́AT[{̎ނɂĈႢ܂B
 *	T[{ID̏Ԃ̓T[{̎ނɂԂݒ肷Kv܂B
 *
 */


#include <stdio.h>					// Wwb_[
#include <windows.h>				// Windows APIpwb_[

#define SERVO_ID		1			// T[{ID̎wu1vɐݒ
#define SERVO_NEW_ID	2			// VT[{ID̎wu2vɐݒ
#define COM_PORT	(char *)"COM1"	// ʐM|[g̎w



/*----------------------------------------------------------------------------*/
/*
 *	TvFʐM|[g
 *
 *	֐FHANDLE CommClose( HANDLE hComm )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *	߂lF
 *		1				
 *
 */
int CommClose( HANDLE hComm )
{
	if( hComm ){
		CloseHandle( hComm );
	}

	return 1;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFʐM|[gJ
 *
 *	֐FHANDLE CommOpen( char *pport )
 *	F
 *		char			*pport		ʐM|[g
 *									T[{ƒʐM\ȃ|[g
 *	߂lF
 *		0				ʐMnhG[
 *		0łȂl		(ʐMpnh)
 *
 *	ʐMx́A115200bpsŒł
 *
 */
HANDLE CommOpen( char *pport )
{
	HANDLE			hComm;		// ʐMpnh
	DCB				cDcb;		// ʐMݒp
	COMMTIMEOUTS	cTimeouts;	// ʐM|[g^CAEgp


	// ʐM|[gJ
	hComm = CreateFileA( pport,
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						0,
						NULL );
	// nh̊mF
	if( hComm == INVALID_HANDLE_VALUE ){
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMݒ
	if( !GetCommState( hComm, &cDcb )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:GetCommState error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}
	cDcb.BaudRate = 115200;				// ʐMx
	cDcb.ByteSize = 8;					// f[^rbg
	cDcb.fParity  = TRUE;				// peB`FbN
	cDcb.Parity   = NOPARITY;			// m[peB
	cDcb.StopBits = ONESTOPBIT;			// 1Xgbvrbg

	if( !SetCommState( hComm, &cDcb )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:GetCommState error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMݒ(ʐM^CAEgݒ)
	// ̓ǂݍݑ҂(ms)
	cTimeouts.ReadIntervalTimeout			= 50;
	// ǂݍ݂̂P̎(ms)
	cTimeouts.ReadTotalTimeoutMultiplier	= 50;
	// ǂݍ݂̒萔(ms)
	cTimeouts.ReadTotalTimeoutConstant		= 50;
	// ݂̂P̎(ms)
	cTimeouts.WriteTotalTimeoutMultiplier	= 0;

	if( !SetCommTimeouts( hComm, &cTimeouts )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:SetCommTimeouts error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );


FuncEnd:
	return hComm;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{̃gNON/OFF
 *
 *	֐Fint RSTorqueOnOff( HANDLE hComm, short sMode )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *		short			sMode		1:gNON
 *									0:gNOFF
 *	߂lF
 *		0ȏ			
 *		0			G[
 *
 */
int RSTorqueOnOff( HANDLE hComm, short sMode )
{
	unsigned char	sendbuf[28];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_ID;			// T[{ID
	sendbuf[3]  = (unsigned char)0x00;				// tO
	sendbuf[4]  = (unsigned char)0x24;				// AhX(0x24=36)
	sendbuf[5]  = (unsigned char)0x01;				// (1byte)
	sendbuf[6]  = (unsigned char)0x01;				// 
	sendbuf[7]  = (unsigned char)(sMode&0x00FF);	// ON/OFFtO
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 8; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[8] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 9, &len, NULL );

	return ret;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{IDύX
 *
 *	֐Fint RSSetID( HANDLE hComm, unsigned char iID )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *		unsigned char	iID			T[{̐VID
 *
 *	߂lF
 *		0ȏ			
 *		0			G[
 *
 */
int RSSetID( HANDLE hComm, unsigned char iID )
{
	unsigned char	sendbuf[28];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_ID;			// T[{ID
	sendbuf[3]  = (unsigned char)0x00;				// tO
	sendbuf[4]  = (unsigned char)0x04;				// AhX(0x24=36)
	sendbuf[5]  = (unsigned char)0x01;				// (1byte)
	sendbuf[6]  = (unsigned char)0x01;				// 
	sendbuf[7]  = (unsigned char)iID;				// T[{̐VID
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 8; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[8] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 9, &len, NULL );

	return ret;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{֐ݒf[^ݍċN
 *		}bvɏ܂ꂽXV\f[^SăT[{
 *		ɏ܂܂B
 *
 * )
 *	ET[{ID̓ɏ܂ꂽiKŕύXɂȂ܂
 *	EʐMx́AT[{ċNĂLɂȂ܂
 *
 *	@T[{IDꍇɂ́AւID]͐V
 *	T[{IDgpKv܂B
 *
 *
 *	֐Fint RSWriteReset( HANDLE hComm )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *
 *	߂lF
 *		0ȏ			
 *		0			G[
 *
 */
int RSWriteReset( HANDLE hComm )
{
	unsigned char	sendbuf[28];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬 (Flash ROM Write)
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_NEW_ID;		// (*)VT[{IDw肷
	sendbuf[3]  = (unsigned char)0x40;				// tO (Flash ROM write)
	sendbuf[4]  = (unsigned char)0xFF;				// AhX(0x24=36)
	sendbuf[5]  = (unsigned char)0x00;				// (0byte)
	sendbuf[6]  = (unsigned char)0x00;				// 
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 7; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[7] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 8, &len, NULL );

	// ҂
	Sleep( 1000 );

	// pPbg쐬 (Servo restart)
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_NEW_ID;		// (*)VT[{IDw肷
	sendbuf[3]  = (unsigned char)0x20;				// tO (Restart)
	sendbuf[4]  = (unsigned char)0xFF;				// AhX(0x24=36)
	sendbuf[5]  = (unsigned char)0x00;				// (0byte)
	sendbuf[6]  = (unsigned char)0x00;				// 
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 7; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[7] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 8, &len, NULL );


	return ret;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{̐ݒ肳ꂽID擾
 *
 *	֐Fshort RSGetID( HANDLE hComm )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *
 *	߂lF
 *		0ȏ			T[{ID
 *		0			G[
 *
 */
short RSGetID( HANDLE hComm )
{
	unsigned char	sendbuf[32];
	unsigned char	readbuf[128];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len, readlen;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_NEW_ID;		// (*)VT[{IDw肷
	sendbuf[3]  = (unsigned char)0x03;				// tO(0x01 | 0x01<<1)
	sendbuf[4]  = (unsigned char)0x00;				// AhX(0x00)
	sendbuf[5]  = (unsigned char)0x00;				// (0byte)
	sendbuf[6]  = (unsigned char)0x01;				// 
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 7; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[7] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 8, &len, NULL );
	if( len < 8 ){
		// MG[
		return -1;
	}

	// M̂߂ɏ҂
	Sleep( 50 );

	// ǂݍ
	memset( readbuf, 0x00, sizeof( readbuf ));
	readlen = 38;
	len = 0;

	ret = ReadFile( hComm, readbuf, readlen, &len, NULL );
	if( len < 38 ){
		// MG[
		return -2;
	}

	// Mf[^̊mF
	sum = readbuf[2];
	for( i = 3; i < 38; i++ ){
		sum = sum ^ readbuf[i];
	}
	if( sum ){
		// `FbNTG[
		return -3;
	}

	// T[{IDԂ
	return (short)readbuf[0x0B];
}


/*----------------------------------------------------------------------------*/
/*
 *	TvFpmain
 *
 *	֐Fint main( )
 *	F
		Ȃ
 *	߂lF
 *		0				G[
 *		0łȂl		
 *
 */
int main( )
{
	HANDLE		hComm = NULL;		// ʐMpnh
	int			ret = 0;			// ^[p
	int			c;					// ͑҂p


    printf( "Sample 4\n" );

	// Il̐ݒ
	ret = 1;

	// ʐM|[gJ
	printf( "COM PORT OPEN [%s]\n", COM_PORT );
	hComm = CommOpen( COM_PORT );
	if( !hComm ){
		printf( "ERROR:Com port open error\n" );
		goto EndMain;
	}

	// gNOFF
	// gN ON=1/OFF=0
	printf( "SEND Torque OFF\n" );
	ret = RSTorqueOnOff( hComm, 0 );	// Torque OFF
	if( ret < 0 ){
		printf( "ERROR:Torque OFF failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// VT[{ID
	printf( "Write New Servo ID [%d}\n", SERVO_NEW_ID );
	ret = RSSetID( hComm, SERVO_NEW_ID );
	if( ret < 0 ){
		printf( "ERROR:Write New Servo ID failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{IDtbVɏŃZbg
	// T[{ID́AVIDw肷Kv
	printf( "Write Reset Servo\n" );
	ret = RSWriteReset( hComm );
	if( ret < 0 ){
		printf( "ERROR:Write Reset Servo failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{IDIăZbg܂ő҂
	// T[{̏݊܂ł̎Ԃ́AT[{̎ނňႤ
	// ł́ARS301CR/302CD̎Ԑݒł
	// ̎ނ̃T[{gpꍇɂ́Aݒ莞ԂύXĂB
	//		RS601CR 9bȏ LEDL
	//		RS301CR 1bȏ
	//		RS302CD 1bȏ
	//		RS303MR 1bȏ
	//		RS304MD 1bȏ
	//		RS401CR 9bȏ
	//		RS402CD 9bȏ
	//	    RS405CB 1bȏ
	//	    RS406CB 1bȏ
	//	    RS204MD 1bȏ
	printf( "Waitting...\n" );
    // ݁ċNԑ҂(RS301CR/302CD)
	Sleep( 2000 );

	// T[{IDǂݏo
	printf( "Read Servo ID\n" );
	ret = RSGetID( hComm );
	if( ret < 0 ){
		printf( "ERROR:Read Servo ID failed[%x]\n", ret );
		goto ErrorEnd;
	}
	printf( "Servo ID : %d\n", ret );

ErrorEnd:
	// ʐM|[g
	printf( "COM PORT CLOSE [%s]\n", COM_PORT );
	CommClose( hComm );

EndMain:
	// I҂
	printf( "Hit Return Key\n" );
	c = getchar( );

	return ret;
}

