/*----------------------------------------------------------------------------*/
/*
 *	Sample3.c
 *	2007/10/25
 *	- 
 *	2008/02/01C
 *	2020/02/18C 
 *	- comportopenۂ̏ύX
 *	- 100xֈړA0x֖߂悤ɂ
 */
/*----------------------------------------------------------------------------*/
/*	Windows APIgpR}hRSV[YT[{̐
 *	(RpCMINGWgpj
 *
 *	(*)T[{wʒuɈړĂT[{̌݊px擾܂
 *
 *	̃t@ĆATAB=4ݒłŋLqĂ܂B
 *
 *	T[{֑MpPbge̐ɂẮAʓrAT[{̎戵
 *	QƂĂB
 *
 *	Copyright (C) 2006-2007 FUTABA Corp.
 *
 *	2008/02/01
 *		Sample2ƋNɕ\C
 *
 */

/*----------------------------------------------------------------------------*/
/*
 *	vOTv
 *
 *	Windows APIgpăR}hRSV[YT[{𓮍삳
 *	T[{ID́Au1vƂ܂B
 *	T[{ID1Ŗꍇɂ͏CKvłB
 *	ʐM|[ǵAuCOM1vƂ܂B
 *	ʐM|[gCOM1Ŗꍇɂ͏CKvłB
 *  T[{ID(T[{ID=1)̃T[{𕡐ڑԂł͓삵܂B
 *
 *	1)Windows APIgpĒʐM|[g
 *		gpʐM|[g͊ɂ킹ďCKvł
 *	2)T[{̃gNONɂ܂
 *	3)T[{px100x܂ōőňړ܂
 *	4)T[{̈ړ܂1b҂܂
 *	5)T[{猻݊pxǂݏo܂
 *	6)T[{̃gNOFFɂ܂
 *
 *	sӁt
 *	vOsꍇɂ́AIɃT[{삵܂B
 *	̃vOł́A1񂾂A100ẍʒuɃT[{ړ܂B
 *	̂ߘAĎsꍇɂ́Aŏ1񂵂T[{삵܂B
 *	1xśAT[{̈ʒu100xȊOɈړĂsĂB
 *
 */


#include <stdio.h>						// Wwb_[
#include <windows.h>					// Windows APIpwb_[

#define SERVO_ID		1				// T[{ID̎wu1vɐݒ
#define COM_PORT		(char *)"COM1"	// ʐM|[g̎w



/*----------------------------------------------------------------------------*/
/*
 *	TvFʐM|[g
 *
 *	֐FHANDLE CommClose( HANDLE hComm )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *	߂lF
 *		1				
 *
 */
int CommClose( HANDLE hComm )
{
	if( hComm ){
		CloseHandle( hComm );
	}

	return 1;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFʐM|[gJ
 *
 *	֐FHANDLE CommOpen( char *pport )
 *	F
 *		char			*pport		ʐM|[g
 *									T[{ƒʐM\ȃ|[g
 *	߂lF
 *		0				ʐMnhG[
 *		0łȂl		(ʐMpnh)
 *
 *	ʐMx́A115200bpsŒł
 *
 */
HANDLE CommOpen( char *pport )
{
	HANDLE			hComm;		// ʐMpnh
	DCB				cDcb;		// ʐMݒp
	COMMTIMEOUTS	cTimeouts;	// ʐM|[g^CAEgp


	// ʐM|[gJ
	hComm = CreateFileA( pport,
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						0,
						NULL );
	// nh̊mF
	if( hComm == INVALID_HANDLE_VALUE ){
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMݒ
	if( !GetCommState( hComm, &cDcb )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:GetCommState error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}
	cDcb.BaudRate = 115200;				// ʐMx
	cDcb.ByteSize = 8;					// f[^rbg
	cDcb.fParity  = TRUE;				// peB`FbN
	cDcb.Parity   = NOPARITY;			// m[peB
	cDcb.StopBits = ONESTOPBIT;			// 1Xgbvrbg

	if( !SetCommState( hComm, &cDcb )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:GetCommState error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMݒ(ʐM^CAEgݒ)
	// ̓ǂݍݑ҂(ms)
	cTimeouts.ReadIntervalTimeout			= 50;
	// ǂݍ݂̂P̎(ms)
	cTimeouts.ReadTotalTimeoutMultiplier	= 50;
	// ǂݍ݂̒萔(ms)
	cTimeouts.ReadTotalTimeoutConstant		= 50;
	// ݂̂P̎(ms)
	cTimeouts.WriteTotalTimeoutMultiplier	= 0;

	if( !SetCommTimeouts( hComm, &cTimeouts )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:SetCommTimeouts error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );


FuncEnd:
	return hComm;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{ړ
 *
 *	֐Fint RSMove( HANDLE hComm, short sPos, unsigned short sTime )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *		short			sPos		ړʒu
 *		unsigned short	sTime		ړ
 *	߂lF
 *		0ȏ			
 *		0			G[
 *
 */
int RSMove( HANDLE hComm, short sPos, unsigned short sTime )
{
	unsigned char	sendbuf[28];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				    // wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				    // wb_[2
	sendbuf[2]  = (unsigned char)SERVO_ID;			    // T[{ID
	sendbuf[3]  = (unsigned char)0x00;				    // tO
	sendbuf[4]  = (unsigned char)0x1E;				    // AhX(0x1E=30)
	sendbuf[5]  = (unsigned char)0x04;				    // (4byte)
	sendbuf[6]  = (unsigned char)0x01;				    // 
	sendbuf[7]  = (unsigned char)(sPos&0x00FF);		    // ʒu
	sendbuf[8]  = (unsigned char)((sPos&0xFF00)>>8);	// ʒu
	sendbuf[9]  = (unsigned char)(sTime&0x00FF);	    // 
	sendbuf[10] = (unsigned char)((sTime&0xFF00)>>8);	// 
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 11; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[11] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 12, &len, NULL );

	return ret;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{̃gNON/OFF
 *
 *	֐Fint RSTorqueOnOff( HANDLE hComm, short sMode )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *		short			sMode		1:gNON
 *									0:gNOFF
 *	߂lF
 *		0ȏ			
 *		0			G[
 *
 */
int RSTorqueOnOff( HANDLE hComm, short sMode )
{
	unsigned char	sendbuf[28];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_ID;			// T[{ID
	sendbuf[3]  = (unsigned char)0x00;				// tO
	sendbuf[4]  = (unsigned char)0x24;				// AhX(0x24=36)
	sendbuf[5]  = (unsigned char)0x01;				// (4byte)
	sendbuf[6]  = (unsigned char)0x01;				// 
	sendbuf[7]  = (unsigned char)(sMode&0x00FF);	// ON/OFFtO
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 8; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[8] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 9, &len, NULL );

	return ret;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{̌݊px擾
 *
 *	֐Fshort RSGetAngle( HANDLE hComm )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *
 *	߂lF
 *		0ȏ			T[{̌݊px(0.1x=1)
 *		0			G[
 *
 */
short RSGetAngle( HANDLE hComm )
{
	unsigned char	sendbuf[32];
	unsigned char	readbuf[128];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len, readlen;
	short			angle;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_ID;			// T[{ID
	sendbuf[3]  = (unsigned char)0x09;				// tO(0x01 | 0x04<<1)
	sendbuf[4]  = (unsigned char)0x00;				// AhX(0x00)
	sendbuf[5]  = (unsigned char)0x00;				// (0byte)
	sendbuf[6]  = (unsigned char)0x01;				// 
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 7; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[7] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 8, &len, NULL );
	if( len < 8 ){
		// MG[
		return -1;
	}

	// M̂߂ɏ҂
	Sleep( 50 );

	// ǂݍ
	memset( readbuf, 0x00, sizeof( readbuf ));
	readlen = 26;
	len = 0;

	ret = ReadFile( hComm, readbuf, readlen, &len, NULL );
	if( len < 26 ){
		// MG[
		return -2;
	}

	// Mf[^̊mF
	sum = readbuf[2];
	for( i = 3; i < 26; i++ ){
		sum = sum ^ readbuf[i];
	}
	if( sum ){
		// `FbNTG[
		return -3;
	}

	angle = ((readbuf[8] << 8) & 0x0000FF00) | (readbuf[7] & 0x000000FF);

	return angle;
}


/*----------------------------------------------------------------------------*/
/*
 *	TvFpmain
 *
 *	֐Fint main( )
 *	F
		Ȃ
 *	߂lF
 *		0				G[
 *		0łȂl		
 *
 */
int main( )
{
	HANDLE		hComm = NULL;		// ʐMpnh
	int			ret = 0;			// ^[p
	int			c;					// ͑҂p


    printf( "Sample 3\n" );

	// Il̐ݒ
	ret = 1;

	// ʐM|[gJ
	printf( "COM PORT OPEN [%s]\n", COM_PORT );
	hComm = CommOpen( COM_PORT );
	if( !hComm ){
		printf( "ERROR:Com port open error\n" );
		goto EndMain;
	}

	// gNON
	// gN ON=1/OFF=0
	printf( "SEND Torque ON\n" );
	ret = RSTorqueOnOff( hComm, 1 );
	if( ret < 0 ){
		printf( "ERROR:Torque ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{ړ
	// 100xɈړ(0.1x=1)
	// =0(ő)
	printf( "SEND Move %.1fdeg / %s\n", 100.0, "max speed");
	ret = RSMove( hComm, 1000, 0 );
	if( ret < 0 ){
		printf( "ERROR:Move ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{̈ړ1b҂
	printf( "Waitting...\n" );
	Sleep( 1000 );

	// T[{̌݊pxǂݏo
	// T[{̌݊px́Aw肵pxɂȂȂꍇ܂B
	// T[{̊px͂̂Ƃ̃T[{̕׏ԂobNbV
	// ԂɂĎwpx菭ႤpxɂȂ܂B
	printf( "Read Servo Anglen\n" );
	ret = RSGetAngle( hComm );
	if( ret < 0 ){
		printf( "ERROR:Read Servo Angle failed[%x]\n", ret );
		goto ErrorEnd;
	}
	printf( "Servo Anglen : %8.1fdeg\n", ((float)ret/10.0f) );

	// T[{̈ړ2b҂
	printf( "Waitting...\n" );
	Sleep( 2000 );

	// T[{ړ
	// 0xɈړ(0.1x=1)
	// =0(ő)
	printf( "SEND Move %.1fdeg / %s\n", 0.0, "max speed");
	ret = RSMove( hComm, 0, 0 );
	if( ret < 0 ){
		printf( "ERROR:Move ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{̈ړ2b҂
	printf( "Waitting...\n" );
	Sleep( 2000 );

	// gNOFF
	// gNOFFƃT[{O͂ŉ]悤ɂȂ܂
	printf( "SEND Torque OFF\n" );
	ret = RSTorqueOnOff( hComm, 0 );
	if( ret < 0 ){
		printf( "ERROR:Torque ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

ErrorEnd:
	// ʐM|[g
	printf( "COM PORT CLOSE [%s]\n", COM_PORT );
	CommClose( hComm );

EndMain:
	// I҂
	printf( "Hit Return Key\n" );
	c = getchar( );

	return ret;
}

