/*----------------------------------------------------------------------------*/
/*
 *	Sample2.c
 *	2007/10/17
 *	- 
 *	2020/02/18
 *	- comportopenۂ̏ύX
 *	- px100xֈړA+90.0  -90.0ֈړ֕ύX
 */

/*----------------------------------------------------------------------------*/
/*	Windows APIgpR}hRSV[YT[{̐
 *	(RpCMINGWgpj
 *
 *	(*)T[{wʒuɎw莞Ԃňړ܂
 *
 *	̃t@ĆATAB=4ݒłŋLqĂ܂B
 *
 *	T[{֑MpPbge̐ɂẮAʓrAT[{̎戵
 *	QƂĂB
 *
 *	(C) 2006 FUTABA Corp.
 *
 */

/*----------------------------------------------------------------------------*/
/*
 *	vOTv
 *
 *	Windows APIgpăR}hRSV[YT[{𓮍삳
 *	T[{ID́Au1vƂ܂B
 *	T[{ID1Ŗꍇɂ͏CKvłB
 *	ʐM|[ǵAuCOM1vƂ܂B
 *	ʐM|[gCOM1Ŗꍇɂ͏CKvłB
 *
 *	1)Windows APIgpĒʐM|[g
 *		gpʐM|[g͊ɂ킹ďCKvł
 *	2)T[{̃gNONɂ܂
 *	3)T[{px90x܂3bňړ܂
 *	4)T[{̈ړ܂3b҂܂
 *	5)T[{px-90x܂3bňړ܂
 *	6)T[{̈ړ܂3b҂܂
 *	7)T[{̃gNOFFɂ܂
 *
 *	sӁt
 *	vOsꍇɂ́AIɃT[{삵܂B
 *	T[{ŏ90ẍʒuɂꍇɂ́AT[{͓܂B
 *
 */


#include <stdio.h>						// Wwb_[
#include <windows.h>					// Windows APIpwb_[

#define SERVO_ID		1				// T[{ID̎wu1vɐݒ
#define COM_PORT		(char *)"COM1"	// ʐM|[g̎w


/*----------------------------------------------------------------------------*/
/*
 *	TvFʐM|[g
 *
 *	֐FHANDLE CommClose( HANDLE hComm )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *	߂lF
 *		1				
 *
 */
int CommClose( HANDLE hComm )
{
	if( hComm ){
		CloseHandle( hComm );
	}

	return 1;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFʐM|[gJ
 *
 *	֐FHANDLE CommOpen( char *pport )
 *	F
 *		char			*pport		ʐM|[g
 *									T[{ƒʐM\ȃ|[g
 *	߂lF
 *		0				ʐMnhG[
 *		0łȂl		(ʐMpnh)
 *
 *	ʐMx́A115200bpsŒł
 *
 */
HANDLE CommOpen( char *pport )
{
	HANDLE			hComm;		// ʐMpnh
	DCB				cDcb;		// ʐMݒp
	COMMTIMEOUTS	cTimeouts;	// ʐM|[g^CAEgp


	// ʐM|[gJ
	hComm = CreateFileA( pport,
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						0,
						NULL );
	// nh̊mF
	if( hComm == INVALID_HANDLE_VALUE ){
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMݒ
	if( !GetCommState( hComm, &cDcb )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:GetCommState error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}
	cDcb.BaudRate = 115200;				// ʐMx
	cDcb.ByteSize = 8;					// f[^rbg
	cDcb.fParity  = TRUE;				// peB`FbN
	cDcb.Parity   = NOPARITY;			// m[peB
	cDcb.StopBits = ONESTOPBIT;			// 1Xgbvrbg

	if( !SetCommState( hComm, &cDcb )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:GetCommState error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMݒ(ʐM^CAEgݒ)
	// ̓ǂݍݑ҂(ms)
	cTimeouts.ReadIntervalTimeout			= 50;
	// ǂݍ݂̂P̎(ms)
	cTimeouts.ReadTotalTimeoutMultiplier	= 50;
	// ǂݍ݂̒萔(ms)
	cTimeouts.ReadTotalTimeoutConstant		= 50;
	// ݂̂P̎(ms)
	cTimeouts.WriteTotalTimeoutMultiplier	= 0;

	if( !SetCommTimeouts( hComm, &cTimeouts )){
		// ʐMݒG[̏ꍇ
		printf( "ERROR:SetCommTimeouts error\n" );
		CommClose( hComm );
		hComm = NULL;
		goto FuncEnd;
	}


	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );


FuncEnd:
	return hComm;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{ړ
 *
 *	֐Fint RSMove( HANDLE hComm, short sPos, unsigned short sTime )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *		short			sPos		ړʒu
 *		unsigned short	sTime		ړ
 *	߂lF
 *		0ȏ			
 *		0			G[
 *
 */
int RSMove( HANDLE hComm, short sPos, unsigned short sTime )
{
	unsigned char	sendbuf[28];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				    // wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				    // wb_[2
	sendbuf[2]  = (unsigned char)SERVO_ID;			    // T[{ID
	sendbuf[3]  = (unsigned char)0x00;				    // tO
	sendbuf[4]  = (unsigned char)0x1E;				    // AhX(0x1E=30)
	sendbuf[5]  = (unsigned char)0x04;				    // (4byte)
	sendbuf[6]  = (unsigned char)0x01;				    // 
	sendbuf[7]  = (unsigned char)(sPos&0x00FF);		    // ʒu
	sendbuf[8]  = (unsigned char)((sPos&0xFF00)>>8);    // ʒu
	sendbuf[9]  = (unsigned char)(sTime&0x00FF);	    // 
	sendbuf[10] = (unsigned char)((sTime&0xFF00)>>8);	// 
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 11; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[11] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 12, &len, NULL );

	return ret;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFT[{̃gNON/OFF
 *
 *	֐Fint RSTorqueOnOff( HANDLE hComm, short sMode )
 *	F
 *		HANDLE			hComm		ʐM|[g̃nh
 *		short			sMode		1:gNON
 *									0:gNOFF
 *	߂lF
 *		0ȏ			
 *		0			G[
 *
 */
int RSTorqueOnOff( HANDLE hComm, short sMode )
{
	unsigned char	sendbuf[28];
	unsigned char	sum;
	int				i;
	int				ret;
	unsigned long	len;


	// nh`FbN
	if( !hComm ){
		return -1;
	}

	// obt@NA
	memset( sendbuf, 0x00, sizeof( sendbuf ));

	// pPbg쐬
	sendbuf[0]  = (unsigned char)0xFA;				// wb_[1
	sendbuf[1]  = (unsigned char)0xAF;				// wb_[2
	sendbuf[2]  = (unsigned char)SERVO_ID;			// T[{ID
	sendbuf[3]  = (unsigned char)0x00;				// tO
	sendbuf[4]  = (unsigned char)0x24;				// AhX(0x24=36)
	sendbuf[5]  = (unsigned char)0x01;				// (4byte)
	sendbuf[6]  = (unsigned char)0x01;				// 
	sendbuf[7]  = (unsigned char)(sMode&0x00FF);	// ON/OFFtO
	// `FbNŤvZ
	sum = sendbuf[2];
	for( i = 3; i < 8; i++ ){
		sum = (unsigned char)(sum ^ sendbuf[i]);
	}
	sendbuf[8] = sum;								// `FbNT

	// ʐMobt@NA
	PurgeComm( hComm, PURGE_RXCLEAR );

	// M
	ret = WriteFile( hComm, &sendbuf, 9, &len, NULL );

	return ret;
}

/*----------------------------------------------------------------------------*/
/*
 *	TvFpmain
 *
 *	֐Fint main( )
 *	F
		Ȃ
 *	߂lF
 *		0				G[
 *		0łȂl		
 *
 */
int main( )
{
	HANDLE		hComm = NULL;		// ʐMpnh
	int			ret = 0;			// ^[p
	int			c;					// ͑҂p


    printf( "Sample 2\n" );

	// Il̐ݒ
	ret = 1;

	// ʐM|[gJ
	printf( "COM PORT OPEN [%s]\n", COM_PORT );
	hComm = CommOpen( COM_PORT );
	if( !hComm ){
		printf( "ERROR:Com port open error\n" );
		goto EndMain;
	}

	// gNON
	// gN ON=1/OFF=0
	printf( "SEND Torque ON\n" );
	ret = RSTorqueOnOff( hComm, 1 );
	if( ret < 0 ){
		printf( "ERROR:Torque ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{ړ
	// 120xɈړ(0.1x=1)
	// =1b(0.01b=1)
	printf( "SEND Move %.1fdeg / %ds\n", 90.0, 2);
	ret = RSMove( hComm, 900, 200 );
	if( ret < 0 ){
		printf( "ERROR:Move ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{̈ړ3b҂
	printf( "Waitting...(3s)\n" );
	Sleep( 3000 );

	// T[{ړ
	// -90xɈړ(0.1x=1)
	// =3b(0.01b=1)
	printf( "SEND Move %.1fdeg / %ds\n", -90.0, 2);
	ret = RSMove( hComm, -900, 200 );
	if( ret < 0 ){
		printf( "ERROR:Move ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

	// T[{̈ړ3b҂
	printf( "Waitting...(3s)\n" );
	Sleep( 3000 );

	// gNOFF
	// gNOFFƃT[{O͂ŉ]悤ɂȂ܂
	printf( "SEND Torque OFF\n" );
	ret = RSTorqueOnOff( hComm, 0 );
	if( ret < 0 ){
		printf( "ERROR:Torque ON failed[%x]\n", ret );
		goto ErrorEnd;
	}

ErrorEnd:
	// ʐM|[g
	printf( "COM PORT CLOSE [%s]\n", COM_PORT );
	CommClose( hComm );

EndMain:
	// I҂
	printf( "Hit Return Key\n" );
	c = getchar( );

	return ret;
}

