;*******************************************************************************
;/ RS485wb_(rs485header.as) Ver1.2  by Futaba Corporation
;*******************************************************************************
;/
;	2007/01/09: 1.1
;				HexCharUpperW,HexCharUpperL,aSleepǉ
;	2007/03/21: 1.2
;				VirtualProtect}NC

#ifdef __hsp30__
#ifndef __RS485HEADER__
#define __RS485HEADER__

;--------+---------+---------+---------+---------+---------+---------+---------+
; Windows API for RS485
;--------+---------+---------+---------+---------+---------+---------+---------+
#include "kernel32.as"			;KERNEL32.DLL
#include "user32.as"			;USER32.DLL
#include "gdi32.as"				;GDI32
#include "advapi32.as"			;ADVAPI32.DLL
#include "winmm.as"				;WINMM.DLL
#include "comctl32.as"			;COMCTL32.DLL


#uselib "KERNEL32.DLL"		
/* --- for rs485comm.as --- */
	#cfunc	global _GetCommModemStatus "GetCommModemStatus" sptr,sptr

#uselib "USER32.DLL"		
/* --- for exobject.as --- */
	#define	global _LoadCursor _LoadCursorA
	#cfunc	global _LoadCursorA "LoadCursorA" sptr,sptr
	#define global _GetWindowLong _GetWindowLongA
	#cfunc	global _GetWindowLongA "GetWindowLongA" sptr,sptr
/* --- for Screen Capture (module) --- */
	#cfunc	global _GetDC "GetDC" sptr

	#cfunc global _GetFocus "GetFocus"

#uselib "WINMM.DLL"		
/* --- for timer (module) --- */
	#cfunc	global _timeGetTime "timeGetTime"

#uselib "gdi32"
#cfunc _GetStockObject "GetStockObject" int

;--------+---------+---------+---------+---------+---------+---------+---------+
; macros and functions for RS485
;--------+---------+---------+---------+---------+---------+---------+---------+
;/ VirtualProtect}N
#module __xdim__
#const  PAGE_NOACCESS           0x0001
#const  PAGE_READONLY           0x0002
#const  PAGE_READWRITE          0x0004
#const  PAGE_WRITECOPY          0x0008
#const  PAGE_EXECUTE            0x0010
#const  PAGE_EXECUTE_READ       0x0020
#const  PAGE_EXECUTE_READWRITE  0x0040
#const  PAGE_EXECUTE_WRITECOPY  0x0080
#const  PAGE_GUARD              0x0100
#const  PAGE_NOCACHE            0x0200
#const  PAGE_WRITECOMBINE       0x0400

#define global xdim(%1,%2) dim %1,%2 :\
	VirtualProtect varptr(%1), %2*4, PAGE_EXECUTE_READWRITE@__xdim__, varptr(flOldProtect@__xdim__)

#global

#define global sysinfo_os sysinfo(0)

;/ 萔}N
#define global FALSE 0
#define global TRUE 1
#define global NULL 0
#define global PI	3.14159265358979323846          ; 

;/ int(word/byte)֐^}N
#define global ctype LOWORD(%1) (%1&0xFFFF)
#define global ctype HIWORD(%1) (%1>>16&0xFFFF)
#define global ctype MAKELONG(%1,%2) (%1&0xFFFF|(%2<<16&0xFFFF0000))
#define global ctype HIBYTE(%1) (%1>>8&0xFF)
#define global ctype LOBYTE(%1) (%1&0xFF)
#define global ctype MAKEWORD(%1,%2) (%1&0xFF|(%2&0xFF<<8))
#define global ctype NOTB(%1) (%1^$FFFFFFFF)
#define global ctype HISWORD(%1) (%1>>16)
#define global ctype LOSWORD(%1) (%1<<16>>16)
#define global ctype HISBYTE(%1) (%1<<16>>24)
#define global ctype LOSBYTE(%1) (%1<<24>>24)
#define global ctype CND(%1,%2,%3) ((%2)*((%1)!=0)|(%3)*((%1)==0))
#define global ctype NOTL(%1) (%1==0)

#define global ctype min(%1,%2) (%1*(%1<=%2)|%2*(%1>%2))
#define global ctype max(%1,%2) (%1*(%1>=%2)|%2*(%1<%2))
#define global ctype sgn(%1) (((%1)>0) - ((%1)<0))

#define global ctype RGB(%1,%2,%3) ((%3<<16&$FF0000)|(%2<<8&$FF00)|(%1&$FF))
#define global ctype GetRValue(%1) (%1&$ff)
#define global ctype GetGValue(%1) (%1>>8&$ff)
#define global ctype GetBValue(%1) (%1>>16&$ff)

#define global ctype HEX(%1) int("$"+(%1))
#define global ctype BINSTR(%1) str((%1)>>7&1)+str((%1)>>6&1)+str((%1)>>5&1)+str((%1)>>4&1)+str((%1)>>3&1)+str((%1)>>2&1)+str((%1)>>1&1)+str((%1)&1)
#define global ctype BIN(%1) cnd(strlen(%1)-1<0,0,int(strmid(%1,strlen(%1)-1,1)))+cnd(strlen(%1)-2<0,0,int(strmid(%1,strlen(%1)-2,1))*2)+cnd(strlen(%1)-3<0,0,int(strmid(%1,strlen(%1)-3,1))*4)+cnd(strlen(%1)-4<0,0,int(strmid(%1,strlen(%1)-4,1))*8)+cnd(strlen(%1)-5<0,0,int(strmid(%1,strlen(%1)-5,1))*16)+cnd(strlen(%1)-6<0,0,int(strmid(%1,strlen(%1)-6,1))*32)+cnd(strlen(%1)-7<0,0,int(strmid(%1,strlen(%1)-7,1))*64)+cnd(strlen(%1)-8<0,0,int(strmid(%1,strlen(%1)-8,1))*128)

#module
#deffunc HexCharUpperW int p1, array p2
	p2=strf("%02x",p1) : CharUpper varptr(p2)
	return
#deffunc HexCharUpperL int p1, array p2
	p2=strf("%04x",p1) : CharUpper varptr(p2)
	return
#global

;/ 64bit֐^}N
; 64bit̉Zs p1+p2
#define global ctype lladd(%1,%2) \
	(%1+%2),(%1(1)+%2(1)+(%1<0^%2<0)*(%1+%2>=0)+(%1<0)*(%2<0))
; 64biťZs p1-p2
#define global ctype llsub(%1,%2) \
	(%1-%2),(%1(1)-%2(1)-(%1>>31=%2>>31)*(%1-%2<0)-(%1>=0)*(%2<0))

#define global ctype itoll(%1) (%1),(%1)>>31	; t32bit64bitɕϊ
#define global ctype llcopy(%1) (%1),(%1(1))	; 64bitRs[

;/ _֐^}N
; {x_(p1)64bit(߂l)֕ϊ
#define global ctype dtoll(%1) (int(%1)),(int(%1/0x10000/0x10000)-(%1<0))
; 64bit(p1){x_(߂l)֕ϊ
#define global ctype lltod(%1) (double(%1(1))*0x10000*0x10000+double(HIWORD(%1))*0x10000+double(LOWORD(%1)))

#module __capture__
;--------+---------+---------+---------+---------+---------+---------+---------+
; Screen Capture (module)
;
;   ScreenCapture p1,p2,p3,p4,p5,p6
;     p1,p2=offset x,y : p3,p4=size x,y : p5,p6=pos x,y
;--------+---------+---------+---------+---------+---------+---------+---------+
#define	SRCCOPY	0x00CC0020	;]]ւ̂܂܃Rs[
#deffunc ScreenCapture int p1, int p2, int p3, int p4, int p5, int p6 
	buffer 1,p3,p4 : wait 10 
	hScrDC = _GetDC(0)		;or hScrDC = _CreateDC("DISPLAY",0,0,0)
	BitBlt hDC, p1, p2, p3, p4, hScrDC, p5, p6, SRCCOPY
	ReleaseDC 0, hScrDC
	redraw 1; 
	return;

#global

#module __timer__
;--------+---------+---------+---------+---------+---------+---------+---------+
; Timer (module)
;
;   aTimeGetTime oldtime
;     
;	qpctime mode
;	
;--------+---------+---------+---------+---------+---------+---------+---------+
#deffunc __init_timer
	dim QPF,2 : dim NowQPC,2 : dim OldQPCa,2 : dim OldQPCb,2 : dim OldQPCc,2
	dim TIMECAPS,2						;TIMECAPS\
	timeGetDevCaps varptr(TIMECAPS),8	;&tc , sizeof(TIMECAPS)
	return

; -----------------------------------------------------------------------------
; aSleep - await+Sleep֐wait(CPUgp80%)
; -----------------------------------------------------------------------------
#deffunc aSleep int p1

	timeBeginPeriod 1					;tc.wPeriodMin

	repeat p1
		await : sleep 10
	loop

	timeEndPeriod 1

	return newtime

; -----------------------------------------------------------------------------
; aTimeGetTime - await+TimeGetTime֐(1ms)wait(CPUgp80%)
; -----------------------------------------------------------------------------
#defcfunc aTimeGetTime int oldtime

	timeBeginPeriod 1					;tc.wPeriodMin

	await
	repeat 1
		newtime=_TimeGetTime()
		if oldtime=newtime : continue 0
	loop

	timeEndPeriod 1

	return newtime

; -----------------------------------------------------------------------------
; qpctime - \ptH[}XJE^ŎԂv
;
;	߂lFOĂяoĂ̌oߎ[sec]
; -----------------------------------------------------------------------------
#define	global qpctime _qpctime
#defcfunc _qpctime int mode
		timeBeginPeriod 1					;tc.wPeriodMin

		QueryPerformanceCounter varptr(NowQPC)
		QueryPerformanceFrequency varptr(QPF)

	switch mode
	case 0
		ER0=llsub(NowQPC,OldQPCa)
		OldQPCa=llcopy(NowQPC)
		swbreak
	case 1
		ER0=llsub(NowQPC,OldQPCb)
		OldQPCb=llcopy(NowQPC)
		swbreak
	case 2
		ER0=llsub(NowQPC,OldQPCc)
		OldQPCc=llcopy(NowQPC)
		swbreak
	swend

	timeEndPeriod 1

	return lltod(ER0)/lltod(QPF)

#global

__init_timer

#endif
#endif
