;*******************************************************************************
;/ RS485ʐMW[(rs485comm.as) Ver2.2  by Futaba Corporation
;*******************************************************************************
;/
;	2006/01/23: 1.0	DCB_status(2)=0x1011
;				LINE EYE SI-30FA RS-232C<->RS485 max115k
;				Best Technology BTE061B USB<->RS485 max1.3M
;
;	2006/01/24: 1.1	DCB_status(2)=0x3021
;				CONTEC COM-2PD(PCI)H PCI<->RS485 max460k
;				Added COM5-9, BaudRate 9.6k-76.8k,153k,230k,691k
;
;	2006/04/12: 1.2	Added COM10
;				DATALINK FD-U485
;
;	2006/09/29: 2.0	J
;	2006/09/29: 2.1	s̏CƖߒǉ
;				pMapPresentPosion:	L(:pMapMapPresentPosion)
;				TransmitShort:	InitMemoryMap삵ȂsC
;				WriteFlashRom:	L(:WrihtFlashRom)
;				PresentVolts:	"GetBufPresentVolts(p1)""GetPresentVolts(p1)"̊֐ǉ
;				ClrMemoryBuf:	"ClrMemoryBuf p1"̖ߒǉ
;				InitMemoryMap:	"InitMemoryMap p1"ɕύX(:InitMemoryMap p1,p2)
;	2009/03/25: 2.2 RS303MR/RS304MD/RS405CBp̖ߒǉ

#ifdef __hsp30__
#ifndef __RS485COMM__
#define __RS485COMM__

; =============================================================================
; T[{ʐMpO[oϐ
; =============================================================================
	dim MemoryBuf,64,256	;[}bvobt@[
	dim TransmitData,64		;Mf[^
	dim TransmitByte,1		;MoCg
	dim ReceiveData,64		;Mf[^
	dim ReceiveByte,1		;MoCg
	dim CheckSumFlg,1		;Mf[^`FbNTtO

#module RS485comm
; -----------------------------------------------------------------------------
; __init_RS485__ - RS485ʐMW[
; -----------------------------------------------------------------------------
#deffunc __init_RS485__
	dim DCB_status,8									;DCB\
	dim COMMTIMEOUTS_status,5							;COMMTIMEOUTS\
	dim COMMPROP_status,16								;COMMPROP\

	GetCommProperties hcom, varptr(COMMPROP_status)		;@\(fobOp)

#define	MS_CTS_ON	0x10
#define	MS_DSR_ON	0x20
	CTS=GetCommModemStatus(hcom,MS_CTS_ON)				;CTS(fobOp)
	DSR=GetCommModemStatus(hcom,MS_DSR_ON)				;DSR(fobOp)

	return

; -----------------------------------------------------------------------------
; rs485open - RS485|[g̃I[v
;
;	rs485open  p1, p2
;		p1: |[gԍ 0="COM1", 1="COM2"...
;		p2: {[[g 0=9600bps, 1=14400bps...
; -----------------------------------------------------------------------------
#define global rs485open(%1,%2,%3=100) _rs485open %1,%2,%3
#deffunc _rs485open int RS485ComNum, int RS485BaudRate, int Timeout

#define GENERIC_WRITE	0x40000000
#define GENERIC_READ	0x80000000
#define OPEN_EXISTING	3
	if RS485ComNum<9 : reg="COM" : else : reg="\\\\.\\COM"
	reg+=str(RS485ComNum+1)
	CreateFile reg,GENERIC_READ|GENERIC_WRITE,0,0,OPEN_EXISTING,0,0 : hcom=stat	;RS485|[g̃I[v

	GetCommState hcom, varptr(DCB_status)				;VA|[g̏

	switch RS485BaudRate
	case 0							; 9.6k
		DCB_status(1)=9600
		swbreak
	case 1							; 14.4k(Ver1.1)
		DCB_status(1)=14400
		swbreak
	case 2							; 19.2k(Ver1.1)
		DCB_status(1)=19200
		swbreak
	case 3							; 28.8k
		DCB_status(1)=28800
		swbreak
	case 4							; 38.4k(Ver1.1)
		DCB_status(1)=38400
		swbreak
	case 5							; 57.6k
		DCB_status(1)=57600
		swbreak
	case 6							; 76.8k
		DCB_status(1)=76800
		swbreak
	case 7							; 115k
		DCB_status(1)=115200
		swbreak
	case 8							; 153k(Ver1.1)
		DCB_status(1)=153600
		swbreak
	case 9							; 230k(Ver1.1)
		DCB_status(1)=230400
		swbreak
	case 10							; 460k
		DCB_status(1)=460800
		swbreak
	case 11							; 691k(Ver1.1)
		DCB_status(1)=691200
		swbreak
	case 12							; 1.38M
		DCB_status(1)=1382400
		swbreak
	swend
	DCB_status(2)=0x1011				;fBitFields(Ver1.0/1.2-)
;	DCB_status(2)=0x3021				;fBitFields(Ver1.1) CONTEC COM-2PD(PCI)H
	wpoke DCB_status,14,0x0800			;XonLim
	wpoke DCB_status,16,0x0200			;XoffLim
	poke DCB_status,18,8				;ByteSize(7or8)
	poke DCB_status,19,0				;Parity(0=NOPARITY,1=ODDPARITY,2=EVENPARITY,3=MARKPARITY)
	poke DCB_status,20,0				;StopBits(0=1bit,2=1.5bit,3=2bit)
	poke DCB_status,21,0x11				;XonChar
	poke DCB_status,22,0x13				;XoffChar

	SetCommState hcom, varptr(DCB_status)				;VA|[g̐ݒ
	
	GetCommTimeouts hcom, varptr(COMMTIMEOUTS_status)	;^CAEg̏

	COMMTIMEOUTS_status(0)=0			;ReadIntervalTimeout
	COMMTIMEOUTS_status(1)=0			;ReadTotalTimeoutMultiplier
	COMMTIMEOUTS_status(2)=Timeout		;ReadTotalTimeoutConstant

	SetCommTimeouts hcom, varptr(COMMTIMEOUTS_status)	;^CAEg̐ݒ

	return

; -----------------------------------------------------------------------------
; rs485close - RS485|[g̃N[Y
;
;	rs485close
; -----------------------------------------------------------------------------
#deffunc rs485close
	CloseHandle hcom									;RS485|[g̃N[Y
	return

; =============================================================================
; T[{ʐMp}NW[
; =============================================================================
#define global pMapModelNumber			0		;fԍ
#define global pMapFirmwareVersion		2		;t@[EFAo[W
#define global pMapServoID				4		;T[{ID
#define global pMapReverse				5		;T[{]
#define global pMapBaudRate				6		;ʐMx
#define global pMapCWAngleLimit 		8		;E~bgpx
#define global pMapCCWAngleLimit 		10		;~bgpx
#define global pMapLoadLimit  			12		;ׂ̃~bgl
#define global pMapTempLimit  			14		;x̃~bgl
#define global pMapDamper				20		;_p[iRS405CBpj
#define global pMapTorqueSilence		22		;PWM̎80msȏMꍇ̋
#define global pMapWarmUpTime			23		;dɏw߈ʒuɒB鎞
#define global pMapCWComplianceMargin	24		;ERvCAX}[W
#define global pMapCCWComplianceMargin	25		;RvCAX}[W
#define global pMapCWComplianceSlope	26		;ERvCAXX[v
#define global pMapCCWComplianceSlope	27		;RvCAXX[v
#define global pMapPunch				28		;p`
#define global pMapGlobalPosition		30		;ڕWʒu
#define global pMapGlobalTime			32		;ړ
#define global pMapAccelerationTime		34		;(10msP)
#define global pMapMaxTorque			35		;őgN
#define global pMapTorqueEnable			36		;gNON
#define global pMapLED					37		;LED
#define global pMapPIDCoefficient		38		;PIDl
#define global pMapPresentPosion		42		;݈ʒu
#define global pMapPresentTime			44		;ݎ
#define global pMapPresentSpeed			46		;ݑx
#define global pMapPresentLoad			48		;ݕ
#define global pMapPresentTemp			50		;݉x
#define global pMapPresentVolts			52		;ݓd
#define global pMapServoStatus			54		;
#define global pMapActiveFlag			55		;ғ
#define global pMapMoving				56		;쒆
#define global pMapLock					57		;bN

#define global ClrMemoryBuf(%1) memset MemoryBuf,0,256,%1*256

#define global ctype GetBufModelNumber(%1)			wpeek(MemoryBuf@,pMapModelNumber+%1*256)
#define global ctype GetBufFirmwareVersion(%1)		peek(MemoryBuf@,pMapFirmwareVersion+%1*256)
#define global ctype GetBufServoID(%1)				peek(MemoryBuf@,pMapServoID+%1*256)
#define global ctype GetBufReverse(%1)				peek(MemoryBuf@,pMapReverse+%1*256)
#define global ctype GetBufBaudRate(%1)				peek(MemoryBuf@,pMapBaudRate+%1*256)
#define global ctype GetBufCWAngleLimit(%1)			LOSWORD(wpeek(MemoryBuf@,pMapCWAngleLimit+%1*256))
#define global ctype GetBufCCWAngleLimit(%1)		LOSWORD(wpeek(MemoryBuf@,pMapCCWAngleLimit+%1*256))
#define global ctype GetBufLoadLimit(%1)			wpeek(MemoryBuf@,pMapLoadLimit+%1*256)
#define global ctype GetBufTempLimit(%1)			wpeek(MemoryBuf@,pMapTempLimit+%1*256)
#define global ctype GetBufDamper(%1)				peek(MemoryBuf@,pMapDamper+%1*256)			;RS405CBp
#define global ctype GetBufTorqueSilence(%1)		peek(MemoryBuf@,pMapTorqueSilence+%1*256)
#define global ctype GetBufWarmUpTime(%1)			peek(MemoryBuf@,pMapWarmUpTime+%1*256)
#define global ctype GetBufCWComplianceMargin(%1)	peek(MemoryBuf@,pMapCWComplianceMargin+%1*256)
#define global ctype GetBufCCWComplianceMargin(%1)	peek(MemoryBuf@,pMapCCWComplianceMargin+%1*256)
#define global ctype GetBufCWComplianceSlope(%1)	peek(MemoryBuf@,pMapCWComplianceSlope+%1*256)
#define global ctype GetBufCCWComplianceSlope(%1)	peek(MemoryBuf@,pMapCCWComplianceSlope+%1*256)
#define global ctype GetBufPunch(%1)				wpeek(MemoryBuf@,pMapPunch+%1*256)
#define global ctype GetBufGlobalPosition(%1)		LOSWORD(wpeek(MemoryBuf@,pMapGlobalPosition+%1*256))
#define global ctype GetBufGlobalTime(%1)			wpeek(MemoryBuf@,pMapGlobalTime+%1*256)
#define global ctype GetBufAccelerationTime(%1)		peek(MemoryBuf@,pMapAccelerationTime+%1*256)
#define global ctype GetBufMaxTorque(%1)			peek(MemoryBuf@,pMapMaxTorque+%1*256)
#define global ctype GetBufTorqueEnable(%1)			peek(MemoryBuf@,pMapTorqueEnable+%1*256)
#define global ctype GetBufLED(%1)					peek(MemoryBuf@,pMapLED+%1*256)
#define global ctype GetBufPIDCoefficient(%1)		peek(MemoryBuf@,pMapPIDCoefficient+%1*256)
#define global ctype GetBufPresentPosion(%1)		LOSWORD(wpeek(MemoryBuf@,pMapPresentPosion+%1*256))
#define global ctype GetBufPresentTime(%1)			wpeek(MemoryBuf@,pMapPresentTime+%1*256)
#define global ctype GetBufPresentSpeed(%1)			LOSWORD(wpeek(MemoryBuf@,pMapPresentSpeed+%1*256))
#define global ctype GetBufPresentLoad(%1)			wpeek(MemoryBuf@,pMapPresentLoad+%1*256)
#define global ctype GetBufPresentTemp(%1)			LOSWORD(wpeek(MemoryBuf@,pMapPresentTemp+%1*256))
#define global ctype GetBufPresentVolts(%1)			wpeek(MemoryBuf@,pMapPresentVolts+%1*256)
#define global ctype GetBufServoStatus(%1)			peek(MemoryBuf@,pMapServoStatus+%1*256)
#define global ctype GetBufActiveFlag(%1)			peek(MemoryBuf@,pMapActiveFlag+%1*256)
#define global ctype GetBufMoving(%1)				peek(MemoryBuf@,pMapMoving+%1*256)
#define global ctype GetBufLock(%1)					peek(MemoryBuf@,pMapLock+%1*256)

#define global SetBufServoID(%1,%2)					poke MemoryBuf@,pMapServoID+%1*256,%2
#define global SetBufReverse(%1,%2)					poke MemoryBuf@,pMapReverse+%1*256,%2
#define global SetBufBaudRate(%1,%2)				poke MemoryBuf@,pMapBaudRate+%1*256,%2
#define global SetBufCWAngleLimit(%1,%2)			wpoke MemoryBuf@,pMapCWAngleLimit+%1*256,%2
#define global SetBufCCWAngleLimit(%1,%2)			wpoke MemoryBuf@,pMapCCWAngleLimit+%1*256,%2
#define global SetBufLoadLimit(%1,%2)				wpoke MemoryBuf@,pMapLoadLimit+%1*256,%2
#define global SetBufDamper(%1,%2)					poke MemoryBuf@,pMapDamper+%1*256,%2
#define global SetBufTorqueSilence(%1,%2)			poke MemoryBuf@,pMapTorqueSilence+%1*256,%2
#define global SetBufWarmUpTime(%1,%2)				wpoke MemoryBuf@,pMapWarmUpTime+%1*256,%2
#define global SetBufCWComplianceMargin(%1,%2)		poke MemoryBuf@,pMapCWComplianceMargin+%1*256,%2
#define global SetBufCCWComplianceMargin(%1,%2)		poke MemoryBuf@,pMapCCWComplianceMargin+%1*256,%2
#define global SetBufCWComplianceSlope(%1,%2)		poke MemoryBuf@,pMapCWComplianceSlope+%1*256,%2
#define global SetBufCCWComplianceSlope(%1,%2)		poke MemoryBuf@,pMapCCWComplianceSlope+%1*256,%2
#define global SetBufPunch(%1,%2)					wpoke MemoryBuf@,pMapPunch+%1*256,%2
#define global SetBufGlobalPosition(%1,%2)			wpoke MemoryBuf@,pMapGlobalPosition+%1*256,%2
#define global SetBufGlobalTime(%1,%2)				wpoke MemoryBuf@,pMapGlobalTime+%1*256,%2
#define global SetBufAccelerationTime(%1,%2)		poke MemoryBuf@,pMapAccelerationTime+%1*256,%2
#define global SetBufMaxTorque(%1,%2)				poke MemoryBuf@,pMapMaxTorque+%1*256,%2
#define global SetBufTorqueEnable(%1,%2)			poke MemoryBuf@,pMapTorqueEnable+%1*256,%2
#define global SetBufLED(%1,%2)						poke MemoryBuf@,pMapLED+%1*256,%2
#define global SetBufPIDCoefficient(%1,%2)			poke MemoryBuf@,pMapPIDCoefficient+%1*256,%2
#define global SetBufLock(%1,%2)					poke MemoryBuf@,pMapLock+%1*256,%2

; -----------------------------------------------------------------------------
; ReceiveReturn - ^[f[^̎M
;
;	ReceiveReturn  p1, p2
;		p1: hcԍ
;		p2: ^[pPbgԍ
; -----------------------------------------------------------------------------
#deffunc ReceiveReturn int ID, int PacketNo 
	switch PacketNo>>1
	case 0	; ACK/NACKpPbg̃^[
		RequestByte=1 
		swbreak
	case 1	; [}bv No.00`No.29^[
		RequestByte=38 : AdrMemMap=0
		swbreak
	case 2	; [}bv No.30`No.59^[
		RequestByte=38 : AdrMemMap=30
		swbreak
	case 3	; [}bv No.20`No.29^[
		RequestByte=18 : AdrMemMap=20
		swbreak
	case 4	; [}bv No.42`No.59^[
		RequestByte=26 : AdrMemMap=42
		swbreak
	case 5	; [}bv No.30`No.41^[
		RequestByte=20 : AdrMemMap=30
		swbreak
	case 6	; [}bv No.60`No.127/139^[
		if (GetBufModelNumber(ID)&0xFF00)=0x3000 : RequestByte=88 : else : RequestByte=76
		AdrMemMap=60
		swbreak
	case 7	; wAhXwoCg^[
		RequestByte=peek(TransmitData@,5)+8 : AdrMemMap=peek(TransmitData@,4)
		swbreak
	swend

	ReadFile hcom, varptr(ReceiveData@), RequestByte, varptr(ReceiveByte@), 0

	CheckSumFlg@=0
	if (PacketNo>>1!0)&(RequestByte=ReceiveByte@) {
		reg=0 : repeat RequestByte-3,2 : reg=(reg^peek(ReceiveData@,cnt)) : loop
		if reg=peek(ReceiveData@,RequestByte-1) {
			CheckSumFlg@=1 : repeat RequestByte-8 : poke MemoryBuf@,AdrMemMap+cnt+ID*256,peek(ReceiveData@,cnt+7) : loop
		}
	}
	return

; -----------------------------------------------------------------------------
; TransmitShort - V[gpPbg̑M
;
;	TransmitShort  p1, p2, p3, p4, p5
;		p1: hcԍ
;		p2: tO
;		p3: [}bṽAhX
;		p4: f[^̃oCg
;		p5: T[{̐
; -----------------------------------------------------------------------------
#deffunc TransmitShort int ID, int Flg, int Adr, int Len, int Count
	TransmitData@=0x0000AFFA
	if ((Flg&0x0F)=0x0F)|(Flg&0x10) : TransmitByte@=8 : else : TransmitByte@=Len+8

	poke TransmitData@,2,ID
	poke TransmitData@,3,Flg
	poke TransmitData@,4,Adr
	poke TransmitData@,5,Len
	poke TransmitData@,6,Count
	repeat TransmitByte@-8 : poke TransmitData@,cnt+7,peek(MemoryBuf@,cnt+Adr+ID*256) : loop
	reg=0 : repeat TransmitByte@-3,2 : reg=(reg^peek(TransmitData@,cnt)) : loop
	poke TransmitData@,TransmitByte@-1,reg
	
	WriteFile hcom, varptr(TransmitData@),TransmitByte@, varptr(Byte), 0	;RS485M

	return

; -----------------------------------------------------------------------------
; SetServoID - ServoID̑M
; SetReverse - ]ݒ̑M
; SetBaudRate - BaudRatȇM
; SetCWAngleLimit - CWAngleLimit̑M
; SetCCWAngleLimit - CCWAngleLimit̑M
; SetLoadLimit - LoadLimit̑M
; SetCWComplianceMargin - CWComplianceMargin̑M
; SetCCWComplianceMargin - CCWComplianceMargin̑M
; SetCWComplianceSlope - CWComplianceSlopȇM
; SetCCWComplianceSlope - CCWComplianceSlopȇM
; SetPunch - Punch̑M
; SetGlobalPosition - GlobalPosition̑M
; SetGlobalTime - GlobalTimȇM
; SetAccelerationTime - AccelerationTimȇM
; SetMaxTorque - MaxTorquȇM
; SetTorqueEnable - TorqueEnablȇM
;	SetTorqueON p1 / SetTorqueOFF p1
; SetLED - LED̑M
;	SetLEDON p1 / SetLEDOFF p1
; SetPIDCoefficient - PIDCoefficient̑M
; SetLock - Lock̑M
;
;	SetServoID(/SetBaudRate/...)  p1, p2
;		p1: MID
;		p2: ServoID(BaudRate/...)
;==============================================================================
; SetServoData - T[{f[^̑M
;
;	SetServoData  p1, p2, p3, p4
;		p1: hcԍ
;		p2: f[^
;		p3: AhX
;		p4: f[^
; -----------------------------------------------------------------------------
#define global SetServoID(%1,%2) SetServoData %1,%2,pMapServoID,1
#define global SetReverse(%1,%2) SetServoData %1,%2,pMapReverse,1
#define global SetBaudRate(%1,%2) SetServoData %1,%2,pMapBaudRate,1
#define global SetCWAngleLimit(%1,%2) SetServoData %1,%2,pMapCWAngleLimit,2
#define global SetCCWAngleLimit(%1,%2) SetServoData %1,%2,pMapCCWAngleLimit,2
#define global SetLoadLimit(%1,%2) SetServoData %1,%2,pMapLoadLimit,2
#define global SetDamper(%1,%2) SetServoData %1,%2,pMapDamper,1	;RS405CBp
#define global SetTorqueSilence(%1,%2) SetServoData %1,%2,pMapTorqueSilence,1
#define global SetWarmUpTime(%1,%2) SetServoData %1,%2,pMapWarmUpTime,1
#define global SetCWComplianceMargin(%1,%2) SetServoData %1,%2,pMapCWComplianceMargin,1
#define global SetCCWComplianceMargin(%1,%2) SetServoData %1,%2,pMapCCWComplianceMargin,1
#define global SetCWComplianceSlope(%1,%2) SetServoData %1,%2,pMapCWComplianceSlope,1
#define global SetCCWComplianceSlope(%1,%2) SetServoData %1,%2,pMapCCWComplianceSlope,1
#define global SetPunch(%1,%2) SetServoData %1,%2,pMapPunch,2
#define global SetGlobalPosition(%1,%2) SetServoData %1,%2,pMapGlobalPosition,2
#define global SetGlobalTime(%1,%2) SetServoData %1,%2,pMapGlobalTime,2
#define global SetAccelerationTime(%1,%2) SetServoData %1,%2,pMapAccelerationTime,1
#define global SetMaxTorque(%1,%2) SetServoData %1,%2,pMapMaxTorque,1
#define global SetTorqueEnable(%1,%2) SetServoData %1,%2,pMapTorqueEnable,1
#define global   SetTorqueON(%1,%2=1) SetTorqueEnable %1,%2
#define global   SetTorqueOFF(%1,%2=0) SetTorqueEnable %1,%2
#define global SetLED(%1,%2) SetServoData %1,%2,pMapLED,1
#define global   SetLEDON(%1,%2=1) SetLED %1,%2
#define global   SetLEDOFF(%1,%2=0) SetLED %1,%2
#define global SetPIDCoefficient(%1,%2) SetServoData %1,%2,pMapPIDCoefficient,1
#define global SetLock(%1,%2) SetServoData %1,%2,pMapLock,1
#deffunc SetServoData int ID, int Data, int Adr, int Len
	if ID=255 {
		repeat 127,1
			if Len=1 : poke MemoryBuf@,Adr+cnt*256,Data : else : wpoke MemoryBuf@,Adr+cnt*256,Data
		loop
	} 
	if Len=1 : poke MemoryBuf@,Adr+ID*256,Data : else : wpoke MemoryBuf@,Adr+ID*256,Data
	TransmitShort ID,0,Adr,Len,1
	return

; -----------------------------------------------------------------------------
; GetModelNumber - GetModelNumber̎M
; GetFirmwareVersion - GetFirmwareVersion̎M
; GetServoID - ServoID̎M
; GetReverse - Reverse̎M
; GetBaudRate - BaudRate̎M
; GetCWAngleLimit - CWAngleLimit̎M
; GetCCWAngleLimit - CCWAngleLimit̎M
; GetLoadLimit - LoadLimit̎M
; GetTempLimit - TempLimit̎M
; GetCWComplianceMargin - CWComplianceMargin̎M
; GetCCWComplianceMargin - CCWComplianceMargin̎M
; GetCWComplianceSlope - CWComplianceSlope̎M
; GetCCWComplianceSlope - CCWComplianceSlope̎M
; GetPunch - Punch̎M
; GetGlobalPosition - GlobalPosition̎M
; GetGlobalTime - GlobalTime̎M
; GetAccelerationTime - AccelerationTime̎M
; GetMaxTorque - MaxTorque̎M
; GetTorqueEnable - TorqueEnable̎M
; GetLED - LED̎M
; GetPIDCoefficient - PIDCoefficient̎M
; GetPresentPosion - PresentPosion̎M
; GetPresentTime - PresentTime̎M
; GetPresentSpeed - PresentSpeed̎M
; GetPresentLoad - PresentLoad̎M
; GetPresentTemp - PresentTemp̎M
; GetServoStatus - ServoStatus̎M
; GetActiveFlag - ActiveFlag̎M
; GetMoving - Moving̎M
; GetLock - Lock̎M
;
;	GetModelNumber(/GetFirmwareVersion/...)(p1)
;		p1: MID
;==============================================================================
; GetServoData - T[{f[^̎M
;	GetServoData(p1, p2, p3)
;		p1: hcԍ
;		p2: AhX
;		p2: f[^
; -----------------------------------------------------------------------------
#define global ctype GetModelNumber(%1) GetServoData(%1,pMapModelNumber,2)
#define global ctype GetFirmwareVersion(%1) GetServoData(%1,pMapFirmwareVersion,1)
#define global ctype GetServoID(%1) GetServoData(%1,pMapServoID,1)
#define global ctype GetReverse(%1) GetServoData(%1,pMapReverse,1)
#define global ctype GetBaudRate(%1) GetServoData(%1,pMapBaudRate,1)
#define global ctype GetCWAngleLimit(%1) GetServoData(%1,pMapCWAngleLimit,2)
#define global ctype GetCCWAngleLimit(%1) GetServoData(%1,pMapCCWAngleLimit,2)
#define global ctype GetLoadLimit(%1) GetServoData(%1,pMapLoadLimit,2)
#define global ctype GetTempLimit(%1) GetServoData(%1,pMapTempLimit,2)
#define global ctype GetDamper(%1) GetServoData(%1,pMapDamper,1)
#define global ctype GetTorqueSilence(%1) GetServoData(%1,pMapTorqueSilence,1)
#define global ctype GetWarmUpTime(%1) GetServoData(%1,pMapWarmUpTime,1)
#define global ctype GetCWComplianceMargin(%1) GetServoData(%1,pMapCWComplianceMargin,1)
#define global ctype GetCCWComplianceMargin(%1) GetServoData(%1,pMapCCWComplianceMargin,1)
#define global ctype GetCWComplianceSlope(%1) GetServoData(%1,pMapCWComplianceSlope,1)
#define global ctype GetCCWComplianceSlope(%1) GetServoData(%1,pMapCCWComplianceSlope,1)
#define global ctype GetPunch(%1) GetServoData(%1,pMapPunch,2)
#define global ctype GetGlobalPosition(%1) GetServoData(%1,pMapGlobalPosition,2)
#define global ctype GetGlobalTime(%1) GetServoData(%1,pMapGlobalTime,2)
#define global ctype GetAccelerationTime(%1) GetServoData(%1,pMapAccelerationTime,1)
#define global ctype GetMaxTorque(%1) GetServoData(%1,pMapMaxTorque,1)
#define global ctype GetTorqueEnable(%1) GetServoData(%1,pMapTorqueEnable,1)
#define global ctype GetLED(%1) GetServoData(%1,pMapLED,1)
#define global ctype GetPIDCoefficient(%1) GetServoData(%1,pMapPIDCoefficient,1)
#define global ctype GetPresentPosion(%1) GetServoData(%1,pMapPresentPosion,2)
#define global ctype GetPresentTime(%1) GetServoData(%1,pMapPresentTime,2)
#define global ctype GetPresentSpeed(%1) GetServoData(%1,pMapPresentSpeed,2)
#define global ctype GetPresentLoad(%1) GetServoData(%1,pMapPresentLoad,2)
#define global ctype GetPresentTemp(%1) GetServoData(%1,pMapPresentTemp,2)
#define global ctype GetPresentVolts(%1) GetServoData(%1,pMapPresentVolts,2)
#define global ctype GetServoStatus(%1) GetServoData(%1,pMapServoStatus,1)
#define global ctype GetActiveFlag(%1) GetServoData(%1,pMapActiveFlag,1)
#define global ctype GetMoving(%1) GetServoData(%1,pMapMoving,1)
#define global ctype GetLock(%1) GetServoData(%1,pMapLock,1)
#defcfunc GetServoData int ID, int Adr, int Len
	TransmitShort ID,15,Adr,Len,0
	ReceiveReturn ID,15
	if (Adr=pMapCWAngleLimit)|(Adr=pMapCCWAngleLimit)|(Adr=pMapGlobalPosition)|(Adr=pMapPresentPosion)|(Adr=pMapPresentSpeed)|(Adr=pMapPresentTemp) : return LOSWORD(wpeek(MemoryBuf@,Adr+ID*256))
	if len=1 : return peek(MemoryBuf@,Adr+ID*256) : else : return wpeek(MemoryBuf@,Adr+ID*256)

; -----------------------------------------------------------------------------
; SetPositionTime - ڕWʒuAړԂ̑Mi^[pPbg̎Mj
;
;	SetPositionTime  p1, p2, p3, (P4)
;		p1: hcԍ
;		p2: ڕWʒu
;		p3: ړ
;		p4: ^[pPbgԍ 0=,1/3/5/7/9/11/13=L,15=nop
; -----------------------------------------------------------------------------
#define global SetPositionTime(%1,%2,%3,%4=0) _SetPositionTime %1,%2,%3,%4
#deffunc _SetPositionTime int ID, int position, int time, int PacketNo
	SetBufGlobalPosition ID,position
	SetBufGlobalTime ID,time
	TransmitShort ID,cnd((PacketNo&1)&(PacketNo!15),PacketNo,0),pMapGlobalPosition,4,1
	if (PacketNo&1)&(PacketNo!15) : ReceiveReturn ID,PacketNo
	return

; -----------------------------------------------------------------------------
; GetReturnData - ^[pPbg̎M
;
;	GetReturnData  p1, p2, (p3), (p4)
;		p1: hcԍ
;		p2: ^[pPbgԍ 1/3/5/7/9/11/13/15
;		p3: AhX
;		p4: f[^
; -----------------------------------------------------------------------------
#define global GetReturnData(%1,%2,%3=0,%4=0) _GetReturnData %1,%2,%3,%4
#deffunc _GetReturnData int ID, int PacketNo, int Adr, int Len
	TransmitShort ID,cnd(PacketNo&1,PacketNo,0),Adr,Len,cnd(PacketNo=15,0,1)
	if PacketNo&1 : ReceiveReturn ID,PacketNo
	return

; -----------------------------------------------------------------------------
; WriteFlashRom - tbVRomւ̏
;
;	WriteFlashRom  p1, (p2)
;		p1: hcԍ
;		p2: 0=ċN, 1=ċNL
; -----------------------------------------------------------------------------
#define global WriteFlashRom(%1,%2=0) TransmitShort %1,cnd(%2,0x60,0x40),0xFF,0,0

; -----------------------------------------------------------------------------
; RestartServo - T[{ċN
; InitMemoryMap - [}bv(4-29)̏
;
;	RestartServo(InitMemoryMap)  p1
;		p1: hcԍ
; -----------------------------------------------------------------------------
#define global RestartServo(%1) TransmitShort %1,0x20,0xFF,0,0
#define global InitMemoryMap(%1) TransmitShort %1,0x10,0xFF,0xFF,0

#global

__init_RS485__	;RS485W[̏

#endif
#endif
;*******************************************************************************